////////////////////////////////////////////////////
// 7seg_chars.h
// (C) jaka
////////////////////////////////////////////////////
// Version history
// v0.1 22.11.2015
//      Initial version.
// v0.2 13.1.2019
//      Added defines for missing ASCII characters between 0x20 (space) and 
//      0x5f (underscore) to have continuous 64 byte ascii table containing
//      all usually needed characters (uppercase only)
// v0.3 29.7.2019
//      Added missing 64-byte ASCII array defines for CA display too

#ifdef CC_DISPLAY
#define _ADDPOINT |0x80
#define _ADD_HEATER_STATUS |(~heaterStatus)
#define _ADD_HEATER_2_STATUS |(~heater2Status)
#define _0P 0xbf
// begin of 64-byte ascii array
#define _SPACE 0x00
#define _EXCLAMATION 0x00
#define _QUOTATION 0x00
#define _HASH 0x00
#define _DOLLAR 0x00
#define _PERCENT 0x00
#define _AMPERSAND 0x00
#define _APOSTROPHE 0x00
#define _LEFT_PARENTHESIS 0x00
#define _RIGHT_PARENTHESIS 0x00
#define _ASTERISK 0x00
#define _PLUS 0x00
#define _COMMA 0x00
#define _MINUS 0x40
#define _PERIOD 0x80
#define _SLASH 0x00
#define _0 0x3f
#define _1 0x06
#define _2 0x5b
#define _3 0x4f
#define _4 0x66
#define _5 0x6d
#define _6 0x7d
#define _7 0x07
#define _8 0x7f
#define _9 0x6f
#define _COLON 0x80
#define _SEMICOLON 0x00
#define _LESS 0x00
#define _EQUALS 0x00
#define _GREATER 0x00
#define _QUESTION 0x53
#define _AT 0x00
#define _A 0x77
#define _B 0x7c
#define _C 0x58
#define _D 0x5e
#define _E 0x79
#define _F 0x71
#define _G 0x3d
#define _H 0x74
#define _I 0x04
#define _J 0x1e
#define _K 0x76
#define _L 0x38
#define _M 0x15
#define _N 0x54
#define _O 0x5c
#define _P 0x73
#define _Q 0x67
#define _R 0x50
#define _S 0x6d
#define _T 0x78
#define _U 0x3e
#define _V 0x1c
#define _W 0x2a
#define _X 0x76
#define _Y 0x6e
#define _Z 0x5b
#define _LEFT_BRACKET 0x00
#define _BACKSLASH 0x00
#define _RIGHT_BRACKET 0x00
#define _CIRCUMFLEX 0x00
#define _UNDERSCORE 0x00
// end of 64-byte ascii array
#define _CELSIUS 0x39
#define _DEGREE 0x04
#define _POINT 0x00

#else
#define _ADDPOINT &0x7f
#define _ADD_HEATER_STATUS &heaterStatus
#define _ADD_HEATER_2_STATUS &heater2Status
#define _0P 0x40
// 64 byte ASCII array starting from 0x20 starts here
#define _SPACE 0xff
#define _EXCLAMATION 0xff
#define _QUOTATION 0xff
#define _HASH 0xff
#define _DOLLAR 0xff
#define _PERCENT 0xff
#define _AMPERSAND 0xff
#define _APOSTROPHE 0xff
#define _LEFT_PARENTHESIS 0xff
#define _RIGHT_PARENTHESIS 0xff
#define _ASTERISK 0xff
#define _PLUS 0xff
#define _COMMA 0x7f
#define _MINUS 0xbf
#define _PERIOD 0x7f
#define _SLASH 0xff
#define _0 0xC0
#define _1 0xf9
#define _2 0xa4
#define _3 0xb0
#define _4 0x99
#define _5 0x92
#define _6 0x82
#define _7 0xf8
#define _8 0x80
#define _9 0x90
#define _COLON 0x7f
#define _SEMICOLON 0xff
#define _LESS 0xff
#define _EQUALS 0xff
#define _GREATER 0xff
#define _QUESTION 0xac
#define _AT 0xff
#define _A 0x88
#define _B 0x83
#define _C 0xa7
#define _D 0xa1
#define _E 0x86
#define _F 0x8e
#define _G 0xc2
#define _H 0x8b
#define _I 0xfb
#define _J 0xe1
#define _K 0x89
#define _L 0xc7
#define _M 0xea
#define _N 0xab
#define _O 0xa3
#define _P 0x8c
#define _Q 0x98
#define _R 0xaf
#define _S 0x92
#define _T 0x87
#define _U 0xc1
#define _V 0xe3
#define _W 0xd5
#define _X 0x89
#define _Y 0x91
#define _Z 0xa4
#define _LEFT_BRACKET 0xff
#define _BACKSLASH 0xff
#define _RIGHT_BRACKET 0xff
#define _CIRCUMFLEX 0xff
#define _UNDERSCORE 0xff
// end of 64-byte ascii array
#define _CELSIUS 0xc6
#define _DEGREE 0xfb
#define _POINT 0x00
#endif


